#version 330 core

// Atributos de vrtice recebidos como entrada ("in") pelo Vertex Shader.
// Veja a funo BuildTrianglesAndAddToVirtualScene() em "main.cpp".
layout (location = 0) in vec4 model_coefficients;
layout (location = 1) in vec4 normal_coefficients;
layout (location = 2) in vec2 texture_coefficients;

// Matrizes computadas no cdigo C++ e enviadas para a GPU
uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

// Atributos de vrtice que sero gerados como sada ("out") pelo Vertex Shader.
// ** Estes sero interpolados pelo rasterizador! ** gerando, assim, valores
// para cada fragmento, os quais sero recebidos como entrada pelo Fragment
// Shader. Veja o arquivo "shader_fragment.glsl".
out vec4 position_world;
out vec4 normal;

void main()
{
    // A varivel gl_Position define a posio final de cada vrtice
    // OBRIGATORIAMENTE em "normalized device coordinates" (NDC), onde cada
    // coeficiente est entre -1 e 1.  (Veja slides 144 e 150 do documento
    // "Aula_09_Projecoes.pdf").
    //
    // O cdigo em "main.cpp" define os vrtices dos modelos em coordenadas
    // locais de cada modelo (array model_coefficients). Abaixo, utilizamos
    // operaes de modelagem, definio da cmera, e projeo, para computar
    // as coordenadas finais em NDC (varivel gl_Position). Aps a execuo
    // deste Vertex Shader, a placa de vdeo (GPU) far a diviso por W. Veja
    // slide 189 do documento "Aula_09_Projecoes.pdf").

    gl_Position = projection * view * model * model_coefficients;

    // Como as variveis acima  (tipo vec4) so vetores com 4 coeficientes,
    // tambm  possvel acessar e modificar cada coeficiente de maneira
    // independente. Esses so indexados pelos nomes x, y, z, e w (nessa
    // ordem, isto , 'x'  o primeiro coeficiente, 'y'  o segundo, ...):
    //
    //     gl_Position.x = model_coefficients.x;
    //     gl_Position.y = model_coefficients.y;
    //     gl_Position.z = model_coefficients.z;
    //     gl_Position.w = model_coefficients.w;
    //

    // Posio do vrtice atual no sistema de coordenadas global (World).
    position_world = model * model_coefficients;

    // Normal do vrtice atual no sistema de coordenadas global (World).
    // Veja slide 94 do documento "Aula_07_Transformacoes_Geometricas_3D.pdf".
    normal = inverse(transpose(model)) * normal_coefficients;
    normal.w = 0.0;
}
